/*****************************************************************************
-  \file : iap2_message_parsing.c
-  \version : $Id: iap2_message_parsing.c, v Exp $
-  \release : $Name:$
-  Contains the source code implementation for parsing the messages sent by Apple Device
-  \component :
-  \author : Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
-  \copyright (c) 2010 - 2016 Advanced Driver Information Technology.
-  This code is developed by Advanced Driver Information Technology.
-  Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
-  All rights reserved.
-  CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
-           DO NOT CHANGE THE CODE MANUALLY
*****************************************************************************/

#include "iap2_parameter_parsing.h"
#include "iap2_parameter_free.h"
#include "iap2_commands.h"
#include "iap2_message_response.h"
#include "iap2_dlt_log.h"
#include "iap2_utility.h"
#include "authentication.h"

EXPORT S32 iAP2ParseDeviceMessage(iAP2Device_st* this_iAP2Device, U8* buf, U32 bufSize);

IMPORT S32 iAP2AppendEAPSessionIdentifier(iAP2Device_t* device, U16 iAP2ExternalAccessoryProtocolSessionIdentifier, U8 iAP2ExternalAccesoryProtocolIdentifier);
IMPORT S32 iAP2DeleteEAPSessionIdentifier(iAP2Device_t* device, U16 iAP2ExternalAccessoryProtocolSessionIdentifier);

/**
 * \addtogroup MessageParsing
 * @{
 */
/***************************************************************************//**
 * Evaluvates & Verifies whether the Start of bytes sent by Apple Device is correct or not.
 * 
 * \param p_SourceBuf  Buffer holding the message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_START_OF_BYTES   When the Start of Bytes are invalid.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2CheckStartOfMsg(U8* p_SourceBuff)
{
    S32 rc = IAP2_INVALID_INPUT_PARAMETER;

    if(p_SourceBuff != NULL)
    {
        if( (p_SourceBuff[0] == 0x40) && (p_SourceBuff[1] == 0x40) )
        {
            rc = IAP2_OK;
        }
        else
        {
            rc = IAP2_INVALID_START_OF_BYTES;
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Start of Bytes Received, p_SourceBuff[0] = 0x%X, p_SourceBuff[1] = 0x%X", p_SourceBuff[0], p_SourceBuff[1]);
        }
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for AuthenticationFailed message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2AuthenticationFailedParameter  Structure having information about AuthenticationFailedParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2AuthenticationFailed(iAP2Device_st* this_iAP2Device, iAP2AuthenticationFailedParameter theiAP2AuthenticationFailedParameter)
{
    S32 rc = IAP2_OK;

    /* Set Device State & Device Error State */
    this_iAP2Device->iAP2DeviceState = iAP2ComError;
    this_iAP2Device->iAP2DeviceErrState = iAP2AuthenticationFailed;
    (*this_iAP2Device->iAP2StackCallbacks.p_iAP2DeviceState_cb)(this_iAP2Device, iAP2ComError, this_iAP2Device->iAP2ContextCallback);
    /* Clear the prefetched certificate data */
    rc = AuthenticationClearCertificate();
    if(rc < 0)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Clear Authentication Certificate failed %d",rc);
    }

    if(this_iAP2Device->iAP2CSCallbacks.iAP2AuthenticationFailed_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2AuthenticationFailed_cb) (this_iAP2Device, &theiAP2AuthenticationFailedParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AuthenticationFailed_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for AuthenticationSucceeded message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2AuthenticationSucceededParameter  Structure having information about AuthenticationSucceededParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2AuthenticationSucceeded(iAP2Device_st* this_iAP2Device, iAP2AuthenticationSucceededParameter theiAP2AuthenticationSucceededParameter)
{
    S32 rc = IAP2_OK;

    /* Set Device State & Device Error State */
    this_iAP2Device->iAP2DeviceState = iAP2AuthenticationPassed;
    this_iAP2Device->iAP2DeviceErrState = iAP2NoError;
    (*this_iAP2Device->iAP2StackCallbacks.p_iAP2DeviceState_cb)(this_iAP2Device, iAP2AuthenticationPassed, this_iAP2Device->iAP2ContextCallback);

    if(this_iAP2Device->iAP2CSCallbacks.iAP2AuthenticationSucceeded_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2AuthenticationSucceeded_cb) (this_iAP2Device, &theiAP2AuthenticationSucceededParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AuthenticationSucceeded_cb() Callback called DevID:%p",this_iAP2Device);
    }

    this_iAP2Device->iAP2DeviceVerified++;
    if (this_iAP2Device->iAP2DeviceVerified == IAP2_AUTH_AND_ID_PASSED)
    {
        /* Set Device State */
        this_iAP2Device->iAP2DeviceState = iAP2DeviceReady;
        /* Send iAP2DeviceReady here, because there are no PowerSourceUpdates in case of Bluetooth */
        (*this_iAP2Device->iAP2StackCallbacks.p_iAP2DeviceState_cb)(this_iAP2Device, iAP2DeviceReady, this_iAP2Device->iAP2ContextCallback);

        this_iAP2Device->iAP2DeviceVerified = 0;
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for RequestAuthenticationCertificate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2RequestAuthenticationCertificateParameter  Structure having information about RequestAuthenticationCertificateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2RequestAuthenticationCertificate(iAP2Device_st* this_iAP2Device, iAP2RequestAuthenticationCertificateParameter theiAP2RequestAuthenticationCertificateParameter)
{
    S32 rc = IAP2_OK;
    iAP2AuthenticationCertificateParameter theiAP2AuthenticationCertificateParameter;
    iAP2AccessoryAuthenticationSerialNumberParameter theiAP2AuthenticationCertificateSerialNumberParameter;

    rc = iAP2GenerateiAP2RequestAuthenticationCertificateResponse(theiAP2RequestAuthenticationCertificateParameter, &theiAP2AuthenticationCertificateParameter, &theiAP2AuthenticationCertificateSerialNumberParameter);
    IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2GenerateiAP2RequestAuthenticationCertificateResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);

    if(theiAP2RequestAuthenticationCertificateParameter.iAP2RequestAuthenticationCertificateSerialNumber_count == 0)
    {
        if(rc == IAP2_OK)
        {
            rc = iAP2AuthenticationCertificate(this_iAP2Device, &theiAP2AuthenticationCertificateParameter);
            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2AuthenticationCertificate() returns: rc = %d DevID:%p", rc, this_iAP2Device);
        }
        iAP2FreeiAP2AuthenticationCertificateParameter(&theiAP2AuthenticationCertificateParameter);
    }
    else if ((theiAP2RequestAuthenticationCertificateParameter.iAP2RequestAuthenticationCertificateSerialNumber_count > 0) && (rc == IAP2_OK))
    {
        rc = iAP2AccessoryAuthenticationSerialNumber(this_iAP2Device, &theiAP2AuthenticationCertificateSerialNumberParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2AccessoryAuthenticationSerialNumber() returns: rc = %d DevID:%p", rc, this_iAP2Device);
        iAP2FreeiAP2AccessoryAuthenticationSerialNumberParameter(&theiAP2AuthenticationCertificateSerialNumberParameter);
    }
    else if ((theiAP2RequestAuthenticationCertificateParameter.iAP2RequestAuthenticationCertificateSerialNumber_count > 0) && (rc > IAP2_OK))
    {
        /* This indicates the condition for Copro 2.0B where serial number will not be available
         * so send the certifiate */
        rc = iAP2AuthenticationCertificate(this_iAP2Device, &theiAP2AuthenticationCertificateParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2AuthenticationCertificate() returns: rc = %d DevID:%p", rc, this_iAP2Device);
        iAP2FreeiAP2AuthenticationCertificateParameter(&theiAP2AuthenticationCertificateParameter);
    }
    else
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "Invalid Input parameter DevID:%p",this_iAP2Device);
    }

    if(this_iAP2Device->iAP2CSCallbacks.iAP2RequestAuthenticationCertificate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2RequestAuthenticationCertificate_cb) (this_iAP2Device, &theiAP2RequestAuthenticationCertificateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RequestAuthenticationCertificate_cb() Callback called DevID:%p",this_iAP2Device);
    }
    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for RequestAuthenticationChallengeResponse message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2RequestAuthenticationChallengeResponseParameter  Structure having information about RequestAuthenticationChallengeResponseParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2RequestAuthenticationChallengeResponse(iAP2Device_st* this_iAP2Device, iAP2RequestAuthenticationChallengeResponseParameter theiAP2RequestAuthenticationChallengeResponseParameter)
{
    S32 rc = IAP2_OK;
    iAP2AuthenticationResponseParameter theiAP2AuthenticationResponseParameter;

    rc = iAP2GenerateiAP2RequestAuthenticationChallengeResponseResponse(theiAP2RequestAuthenticationChallengeResponseParameter, &theiAP2AuthenticationResponseParameter);
    IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2GenerateiAP2RequestAuthenticationChallengeResponseResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    if(rc == IAP2_OK)
    {
        rc = iAP2AuthenticationResponse(this_iAP2Device, &theiAP2AuthenticationResponseParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2AuthenticationResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    }
    iAP2FreeiAP2AuthenticationResponseParameter(&theiAP2AuthenticationResponseParameter);

    if(this_iAP2Device->iAP2CSCallbacks.iAP2RequestAuthenticationChallengeResponse_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2RequestAuthenticationChallengeResponse_cb) (this_iAP2Device, &theiAP2RequestAuthenticationChallengeResponseParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RequestAuthenticationChallengeResponse_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StartIdentification message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StartIdentificationParameter  Structure having information about StartIdentificationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StartIdentification(iAP2Device_st* this_iAP2Device, iAP2StartIdentificationParameter theiAP2StartIdentificationParameter)
{
    S32 rc = IAP2_OK;
    iAP2IdentificationInformationParameter theiAP2IdentificationInformationParameter;

    rc = iAP2GenerateiAP2StartIdentificationResponse(this_iAP2Device, &theiAP2IdentificationInformationParameter);
    IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2GenerateiAP2StartIdentificationResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    if(rc == IAP2_OK)
    {
        rc = iAP2IdentificationInformation(this_iAP2Device, &theiAP2IdentificationInformationParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2IdentificationInformation() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    }
    iAP2FreeiAP2IdentificationInformationParameter(&theiAP2IdentificationInformationParameter);

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StartIdentification_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StartIdentification_cb) (this_iAP2Device, &theiAP2StartIdentificationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StartIdentification_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for IdentificationAccepted message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2IdentificationAcceptedParameter  Structure having information about IdentificationAcceptedParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2IdentificationAccepted(iAP2Device_st* this_iAP2Device, iAP2IdentificationAcceptedParameter theiAP2IdentificationAcceptedParameter)
{
    S32 rc = IAP2_OK;

    /* Set Device State & Device Error State */
    this_iAP2Device->iAP2DeviceState = iAP2IdentificationPassed;
    this_iAP2Device->iAP2DeviceErrState = iAP2NoError;
    (*this_iAP2Device->iAP2StackCallbacks.p_iAP2DeviceState_cb)(this_iAP2Device, iAP2IdentificationPassed, this_iAP2Device->iAP2ContextCallback);


    if(this_iAP2Device->iAP2CSCallbacks.iAP2IdentificationAccepted_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2IdentificationAccepted_cb) (this_iAP2Device, &theiAP2IdentificationAcceptedParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2IdentificationAccepted_cb() Callback called DevID:%p",this_iAP2Device);
    }

    this_iAP2Device->iAP2DeviceVerified++;
    if (this_iAP2Device->iAP2DeviceVerified == IAP2_AUTH_AND_ID_PASSED)
    {
        /* Set Device State */
        this_iAP2Device->iAP2DeviceState = iAP2DeviceReady;
        /* Send iAP2DeviceReady here, because there are no PowerSourceUpdates in case of Bluetooth */
        (*this_iAP2Device->iAP2StackCallbacks.p_iAP2DeviceState_cb)(this_iAP2Device, iAP2DeviceReady, this_iAP2Device->iAP2ContextCallback);

        this_iAP2Device->iAP2DeviceVerified = 0;
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for IdentificationRejected message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2IdentificationRejectedParameter  Structure having information about IdentificationRejectedParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2IdentificationRejected(iAP2Device_st* this_iAP2Device, iAP2IdentificationRejectedParameter theiAP2IdentificationRejectedParameter)
{
    S32 rc = IAP2_OK;
    iAP2IdentificationInformationParameter theiAP2IdentificationInformationParameter;

    /* Set Device State & Device Error State */
    this_iAP2Device->iAP2DeviceState = iAP2ComError;
    this_iAP2Device->iAP2DeviceErrState = iAP2IdentificationFailed;
    (*this_iAP2Device->iAP2StackCallbacks.p_iAP2DeviceState_cb)(this_iAP2Device, iAP2ComError, this_iAP2Device->iAP2ContextCallback);

    rc = iAP2ReplaceRejectedIdentificationInformationParameter(this_iAP2Device, theiAP2IdentificationRejectedParameter);
    memset(&theiAP2IdentificationInformationParameter, 0 , sizeof(iAP2IdentificationInformationParameter) );
    if(rc == IAP2_OK)
    {
        rc = iAP2GenerateiAP2StartIdentificationResponse(this_iAP2Device, &theiAP2IdentificationInformationParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2GenerateiAP2StartIdentificationResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    }
    if(rc == IAP2_OK)
    {
        rc = iAP2IdentificationInformation(this_iAP2Device, &theiAP2IdentificationInformationParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2IdentificationInformation() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    }
    iAP2FreeiAP2IdentificationInformationParameter(&theiAP2IdentificationInformationParameter);
    if(this_iAP2Device->iAP2CSCallbacks.iAP2IdentificationRejected_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2IdentificationRejected_cb) (this_iAP2Device, &theiAP2IdentificationRejectedParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2IdentificationRejected_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for OOBBTPairingLinkKeyInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2OOBBTPairingLinkKeyInformationParameter  Structure having information about OOBBTPairingLinkKeyInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2OOBBTPairingLinkKeyInformation(iAP2Device_st* this_iAP2Device, iAP2OOBBTPairingLinkKeyInformationParameter theiAP2OOBBTPairingLinkKeyInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2OOBBTPairingLinkKeyInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2OOBBTPairingLinkKeyInformation_cb) (this_iAP2Device, &theiAP2OOBBTPairingLinkKeyInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2OOBBTPairingLinkKeyInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StartOOBBTPairing message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StartOOBBTPairingParameter  Structure having information about StartOOBBTPairingParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StartOOBBTPairing(iAP2Device_st* this_iAP2Device, iAP2StartOOBBTPairingParameter theiAP2StartOOBBTPairingParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StartOOBBTPairing_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StartOOBBTPairing_cb) (this_iAP2Device, &theiAP2StartOOBBTPairingParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StartOOBBTPairing_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StopOOBBTPairing message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StopOOBBTPairingParameter  Structure having information about StopOOBBTPairingParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StopOOBBTPairing(iAP2Device_st* this_iAP2Device, iAP2StopOOBBTPairingParameter theiAP2StopOOBBTPairingParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StopOOBBTPairing_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StopOOBBTPairing_cb) (this_iAP2Device, &theiAP2StopOOBBTPairingParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StopOOBBTPairing_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for RouteGuidanceManeuverUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2RouteGuidanceManeuverUpdateParameter  Structure having information about RouteGuidanceManeuverUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2RouteGuidanceManeuverUpdate(iAP2Device_st* this_iAP2Device, iAP2RouteGuidanceManeuverUpdateParameter theiAP2RouteGuidanceManeuverUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2RouteGuidanceManeuverUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2RouteGuidanceManeuverUpdate_cb) (this_iAP2Device, &theiAP2RouteGuidanceManeuverUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceManeuverUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for RouteGuidanceUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2RouteGuidanceUpdateParameter  Structure having information about RouteGuidanceUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2RouteGuidanceUpdate(iAP2Device_st* this_iAP2Device, iAP2RouteGuidanceUpdateParameter theiAP2RouteGuidanceUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2RouteGuidanceUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2RouteGuidanceUpdate_cb) (this_iAP2Device, &theiAP2RouteGuidanceUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RouteGuidanceUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for AssistiveTouchInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2AssistiveTouchInformationParameter  Structure having information about AssistiveTouchInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2AssistiveTouchInformation(iAP2Device_st* this_iAP2Device, iAP2AssistiveTouchInformationParameter theiAP2AssistiveTouchInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2AssistiveTouchInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2AssistiveTouchInformation_cb) (this_iAP2Device, &theiAP2AssistiveTouchInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2AssistiveTouchInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for BluetoothConnectionUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2BluetoothConnectionUpdateParameter  Structure having information about BluetoothConnectionUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2BluetoothConnectionUpdate(iAP2Device_st* this_iAP2Device, iAP2BluetoothConnectionUpdateParameter theiAP2BluetoothConnectionUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2BluetoothConnectionUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2BluetoothConnectionUpdate_cb) (this_iAP2Device, &theiAP2BluetoothConnectionUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2BluetoothConnectionUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for CallStateUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2CallStateUpdateParameter  Structure having information about CallStateUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2CallStateUpdate(iAP2Device_st* this_iAP2Device, iAP2CallStateUpdateParameter theiAP2CallStateUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2CallStateUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2CallStateUpdate_cb) (this_iAP2Device, &theiAP2CallStateUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CallStateUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for CommunicationsUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2CommunicationsUpdateParameter  Structure having information about CommunicationsUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2CommunicationsUpdate(iAP2Device_st* this_iAP2Device, iAP2CommunicationsUpdateParameter theiAP2CommunicationsUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2CommunicationsUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2CommunicationsUpdate_cb) (this_iAP2Device, &theiAP2CommunicationsUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2CommunicationsUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for ListUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2ListUpdateParameter  Structure having information about ListUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2ListUpdate(iAP2Device_st* this_iAP2Device, iAP2ListUpdateParameter theiAP2ListUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2ListUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2ListUpdate_cb) (this_iAP2Device, &theiAP2ListUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2ListUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceAuthenticationCertificate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceAuthenticationCertificateParameter  Structure having information about DeviceAuthenticationCertificateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceAuthenticationCertificate(iAP2Device_st* this_iAP2Device, iAP2DeviceAuthenticationCertificateParameter theiAP2DeviceAuthenticationCertificateParameter)
{
    S32 rc = IAP2_OK;
    iAP2RequestDeviceAuthenticationChallengeResponseParameter theiAP2RequestDeviceAuthenticationChallengeResponseParameter;

    rc = iAP2GenerateiAP2DeviceAuthenticationCertificateResponse(theiAP2DeviceAuthenticationCertificateParameter, &theiAP2RequestDeviceAuthenticationChallengeResponseParameter);
    IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2GenerateiAP2DeviceAuthenticationCertificateResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    if(rc == IAP2_OK)
    {
        rc = iAP2RequestDeviceAuthenticationChallengeResponse(this_iAP2Device, &theiAP2RequestDeviceAuthenticationChallengeResponseParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2RequestDeviceAuthenticationChallengeResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    }
    else
    {
        iAP2DeviceAuthenticationFailedParameter theiAP2DeviceAuthenticationFailedParameter;

        memset(&theiAP2DeviceAuthenticationFailedParameter, 0, sizeof(iAP2DeviceAuthenticationFailedParameter) );
        rc = iAP2DeviceAuthenticationFailed(this_iAP2Device, &theiAP2DeviceAuthenticationFailedParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2DeviceAuthenticationFailed() returns rc = %d DevID:%p", rc, this_iAP2Device);
        /* Need not free as the associated parameters are empty */
        /* iAP2FreeiAP2DeviceAuthenticationFailedParameter(&theiAP2DeviceAuthenticationFailedParameter); */
    }
    iAP2FreeiAP2RequestDeviceAuthenticationChallengeResponseParameter(&theiAP2RequestDeviceAuthenticationChallengeResponseParameter);

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceAuthenticationCertificate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceAuthenticationCertificate_cb) (this_iAP2Device, &theiAP2DeviceAuthenticationCertificateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceAuthenticationCertificate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceAuthenticationResponse message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceAuthenticationResponseParameter  Structure having information about DeviceAuthenticationResponseParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceAuthenticationResponse(iAP2Device_st* this_iAP2Device, iAP2DeviceAuthenticationResponseParameter theiAP2DeviceAuthenticationResponseParameter)
{
    S32 rc = IAP2_OK;
    iAP2DeviceAuthenticationSucceededParameter theiAP2DeviceAuthenticationSucceededParameter;

    rc = iAP2GenerateiAP2DeviceAuthenticationResponseResponse(theiAP2DeviceAuthenticationResponseParameter, &theiAP2DeviceAuthenticationSucceededParameter);
    IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2GenerateiAP2DeviceAuthenticationResponseResponse() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    if(rc == IAP2_OK)
    {
        rc = iAP2DeviceAuthenticationSucceeded(this_iAP2Device, &theiAP2DeviceAuthenticationSucceededParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2DeviceAuthenticationSucceeded() returns: rc = %d DevID:%p", rc, this_iAP2Device);
    }
    else
    {
        iAP2DeviceAuthenticationFailedParameter theiAP2DeviceAuthenticationFailedParameter;

        memset(&theiAP2DeviceAuthenticationFailedParameter, 0, sizeof(iAP2DeviceAuthenticationFailedParameter) );
        rc = iAP2DeviceAuthenticationFailed(this_iAP2Device, &theiAP2DeviceAuthenticationFailedParameter);
        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2DeviceAuthenticationFailed() returns rc = %d DevID:%p", rc, this_iAP2Device);
        /* Need not free as the associated parameters are empty */
        /* iAP2FreeiAP2DeviceAuthenticationFailedParameter(&theiAP2DeviceAuthenticationFailedParameter); */
    }
    /* Need not free as the associated parameters are empty */
    /* iAP2FreeiAP2DeviceAuthenticationSucceededParameter(&theiAP2DeviceAuthenticationSucceededParameter); */

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceAuthenticationResponse_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceAuthenticationResponse_cb) (this_iAP2Device, &theiAP2DeviceAuthenticationResponseParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceAuthenticationResponse_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceInformationUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceInformationUpdateParameter  Structure having information about DeviceInformationUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceInformationUpdate(iAP2Device_st* this_iAP2Device, iAP2DeviceInformationUpdateParameter theiAP2DeviceInformationUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceInformationUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceInformationUpdate_cb) (this_iAP2Device, &theiAP2DeviceInformationUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceInformationUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceLanguageUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceLanguageUpdateParameter  Structure having information about DeviceLanguageUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceLanguageUpdate(iAP2Device_st* this_iAP2Device, iAP2DeviceLanguageUpdateParameter theiAP2DeviceLanguageUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceLanguageUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceLanguageUpdate_cb) (this_iAP2Device, &theiAP2DeviceLanguageUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceLanguageUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceTimeUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceTimeUpdateParameter  Structure having information about DeviceTimeUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceTimeUpdate(iAP2Device_st* this_iAP2Device, iAP2DeviceTimeUpdateParameter theiAP2DeviceTimeUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceTimeUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceTimeUpdate_cb) (this_iAP2Device, &theiAP2DeviceTimeUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceTimeUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceUUIDUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceUUIDUpdateParameter  Structure having information about DeviceUUIDUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceUUIDUpdate(iAP2Device_st* this_iAP2Device, iAP2DeviceUUIDUpdateParameter theiAP2DeviceUUIDUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceUUIDUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceUUIDUpdate_cb) (this_iAP2Device, &theiAP2DeviceUUIDUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceUUIDUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for WirelessCarPlayUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2WirelessCarPlayUpdateParameter  Structure having information about WirelessCarPlayUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2WirelessCarPlayUpdate(iAP2Device_st* this_iAP2Device, iAP2WirelessCarPlayUpdateParameter theiAP2WirelessCarPlayUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2WirelessCarPlayUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2WirelessCarPlayUpdate_cb) (this_iAP2Device, &theiAP2WirelessCarPlayUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2WirelessCarPlayUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceTransportIdentifierNotification message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceTransportIdentifierNotificationParameter  Structure having information about DeviceTransportIdentifierNotificationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceTransportIdentifierNotification(iAP2Device_st* this_iAP2Device, iAP2DeviceTransportIdentifierNotificationParameter theiAP2DeviceTransportIdentifierNotificationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceTransportIdentifierNotification_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceTransportIdentifierNotification_cb) (this_iAP2Device, &theiAP2DeviceTransportIdentifierNotificationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceTransportIdentifierNotification_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StartExternalAccessoryProtocolSession message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StartExternalAccessoryProtocolSessionParameter  Structure having information about StartExternalAccessoryProtocolSessionParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StartExternalAccessoryProtocolSession(iAP2Device_st* this_iAP2Device, iAP2StartExternalAccessoryProtocolSessionParameter theiAP2StartExternalAccessoryProtocolSessionParameter)
{
    S32 rc = IAP2_OK;

    rc = iAP2AppendEAPSessionIdentifier(this_iAP2Device,
                                        *(theiAP2StartExternalAccessoryProtocolSessionParameter.iAP2ExternalAccessoryProtocolSessionIdentifier),
                                        *(theiAP2StartExternalAccessoryProtocolSessionParameter.iAP2ExternalAccesoryProtocolIdentifier) );

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StartExternalAccessoryProtocolSession_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StartExternalAccessoryProtocolSession_cb) (this_iAP2Device, &theiAP2StartExternalAccessoryProtocolSessionParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StartExternalAccessoryProtocolSession_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StopExternalAccessoryProtocolSession message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StopExternalAccessoryProtocolSessionParameter  Structure having information about StopExternalAccessoryProtocolSessionParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StopExternalAccessoryProtocolSession(iAP2Device_st* this_iAP2Device, iAP2StopExternalAccessoryProtocolSessionParameter theiAP2StopExternalAccessoryProtocolSessionParameter)
{
    S32 rc = IAP2_OK;

    rc = iAP2DeleteEAPSessionIdentifier(this_iAP2Device, *(theiAP2StopExternalAccessoryProtocolSessionParameter.iAP2ExternalAccessoryProtocolSessionIdentifier) );

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StopExternalAccessoryProtocolSession_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StopExternalAccessoryProtocolSession_cb) (this_iAP2Device, &theiAP2StopExternalAccessoryProtocolSessionParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StopExternalAccessoryProtocolSession_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for DeviceHIDReport message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2DeviceHIDReportParameter  Structure having information about DeviceHIDReportParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2DeviceHIDReport(iAP2Device_st* this_iAP2Device, iAP2DeviceHIDReportParameter theiAP2DeviceHIDReportParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2DeviceHIDReport_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2DeviceHIDReport_cb) (this_iAP2Device, &theiAP2DeviceHIDReportParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2DeviceHIDReport_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StartNativeHID message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StartNativeHIDParameter  Structure having information about StartNativeHIDParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StartNativeHID(iAP2Device_st* this_iAP2Device, iAP2StartNativeHIDParameter theiAP2StartNativeHIDParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StartNativeHID_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StartNativeHID_cb) (this_iAP2Device, &theiAP2StartNativeHIDParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StartNativeHID_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for GPRMCDataStatusValuesNotification message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2GPRMCDataStatusValuesNotificationParameter  Structure having information about GPRMCDataStatusValuesNotificationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2GPRMCDataStatusValuesNotification(iAP2Device_st* this_iAP2Device, iAP2GPRMCDataStatusValuesNotificationParameter theiAP2GPRMCDataStatusValuesNotificationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2GPRMCDataStatusValuesNotification_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2GPRMCDataStatusValuesNotification_cb) (this_iAP2Device, &theiAP2GPRMCDataStatusValuesNotificationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2GPRMCDataStatusValuesNotification_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StartLocationInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StartLocationInformationParameter  Structure having information about StartLocationInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StartLocationInformation(iAP2Device_st* this_iAP2Device, iAP2StartLocationInformationParameter theiAP2StartLocationInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StartLocationInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StartLocationInformation_cb) (this_iAP2Device, &theiAP2StartLocationInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StartLocationInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StopLocationInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StopLocationInformationParameter  Structure having information about StopLocationInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StopLocationInformation(iAP2Device_st* this_iAP2Device, iAP2StopLocationInformationParameter theiAP2StopLocationInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StopLocationInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StopLocationInformation_cb) (this_iAP2Device, &theiAP2StopLocationInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StopLocationInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for MediaLibraryInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2MediaLibraryInformationParameter  Structure having information about MediaLibraryInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2MediaLibraryInformation(iAP2Device_st* this_iAP2Device, iAP2MediaLibraryInformationParameter theiAP2MediaLibraryInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2MediaLibraryInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2MediaLibraryInformation_cb) (this_iAP2Device, &theiAP2MediaLibraryInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for MediaLibraryUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2MediaLibraryUpdateParameter  Structure having information about MediaLibraryUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2MediaLibraryUpdate(iAP2Device_st* this_iAP2Device, iAP2MediaLibraryUpdateParameter theiAP2MediaLibraryUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2MediaLibraryUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2MediaLibraryUpdate_cb) (this_iAP2Device, &theiAP2MediaLibraryUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2MediaLibraryUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for NowPlayingUpdateParameter message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2NowPlayingUpdateParameter  Structure having information about NowPlayingUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2NowPlayingUpdateParameter(iAP2Device_st* this_iAP2Device, iAP2NowPlayingUpdateParameter theiAP2NowPlayingUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2NowPlayingUpdateParameter_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2NowPlayingUpdateParameter_cb) (this_iAP2Device, &theiAP2NowPlayingUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2NowPlayingUpdateParameter_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for PowerUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2PowerUpdateParameter  Structure having information about PowerUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2PowerUpdate(iAP2Device_st* this_iAP2Device, iAP2PowerUpdateParameter theiAP2PowerUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2PowerUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2PowerUpdate_cb) (this_iAP2Device, &theiAP2PowerUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2PowerUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for TelephonyCallStateInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2TelephonyCallStateInformationParameter  Structure having information about TelephonyCallStateInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2TelephonyCallStateInformation(iAP2Device_st* this_iAP2Device, iAP2TelephonyCallStateInformationParameter theiAP2TelephonyCallStateInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2TelephonyCallStateInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2TelephonyCallStateInformation_cb) (this_iAP2Device, &theiAP2TelephonyCallStateInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonyCallStateInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for TelephonyUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2TelephonyUpdateParameter  Structure having information about TelephonyUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2TelephonyUpdate(iAP2Device_st* this_iAP2Device, iAP2TelephonyUpdateParameter theiAP2TelephonyUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2TelephonyUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2TelephonyUpdate_cb) (this_iAP2Device, &theiAP2TelephonyUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2TelephonyUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for USBDeviceModeAudioInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2USBDeviceModeAudioInformationParameter  Structure having information about USBDeviceModeAudioInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2USBDeviceModeAudioInformation(iAP2Device_st* this_iAP2Device, iAP2USBDeviceModeAudioInformationParameter theiAP2USBDeviceModeAudioInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2USBDeviceModeAudioInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2USBDeviceModeAudioInformation_cb) (this_iAP2Device, &theiAP2USBDeviceModeAudioInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2USBDeviceModeAudioInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StartVehicleStatusUpdates message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StartVehicleStatusUpdatesParameter  Structure having information about StartVehicleStatusUpdatesParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StartVehicleStatusUpdates(iAP2Device_st* this_iAP2Device, iAP2StartVehicleStatusUpdatesParameter theiAP2StartVehicleStatusUpdatesParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StartVehicleStatusUpdates_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StartVehicleStatusUpdates_cb) (this_iAP2Device, &theiAP2StartVehicleStatusUpdatesParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StartVehicleStatusUpdates_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for StopVehicleStatusUpdates message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2StopVehicleStatusUpdatesParameter  Structure having information about StopVehicleStatusUpdatesParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2StopVehicleStatusUpdates(iAP2Device_st* this_iAP2Device, iAP2StopVehicleStatusUpdatesParameter theiAP2StopVehicleStatusUpdatesParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2StopVehicleStatusUpdates_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2StopVehicleStatusUpdates_cb) (this_iAP2Device, &theiAP2StopVehicleStatusUpdatesParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2StopVehicleStatusUpdates_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for VoiceOverCursorUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2VoiceOverCursorUpdateParameter  Structure having information about VoiceOverCursorUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2VoiceOverCursorUpdate(iAP2Device_st* this_iAP2Device, iAP2VoiceOverCursorUpdateParameter theiAP2VoiceOverCursorUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2VoiceOverCursorUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2VoiceOverCursorUpdate_cb) (this_iAP2Device, &theiAP2VoiceOverCursorUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverCursorUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for VoiceOverUpdate message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2VoiceOverUpdateParameter  Structure having information about VoiceOverUpdateParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2VoiceOverUpdate(iAP2Device_st* this_iAP2Device, iAP2VoiceOverUpdateParameter theiAP2VoiceOverUpdateParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2VoiceOverUpdate_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2VoiceOverUpdate_cb) (this_iAP2Device, &theiAP2VoiceOverUpdateParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2VoiceOverUpdate_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for RequestAccessoryWiFiConfigurationInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2RequestAccessoryWiFiConfigurationInformationParameter  Structure having information about RequestAccessoryWiFiConfigurationInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2RequestAccessoryWiFiConfigurationInformation(iAP2Device_st* this_iAP2Device, iAP2RequestAccessoryWiFiConfigurationInformationParameter theiAP2RequestAccessoryWiFiConfigurationInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2RequestAccessoryWiFiConfigurationInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2RequestAccessoryWiFiConfigurationInformation_cb) (this_iAP2Device, &theiAP2RequestAccessoryWiFiConfigurationInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2RequestAccessoryWiFiConfigurationInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Verify what has to be done for WiFiInformation message from Apple Device.
 * 
 * \param thisDevice  Structure having information about the device connected to the target.
 * \param theiAP2WiFiInformationParameter  Structure having information about WiFiInformationParameter Message from Apple Device.
 * 
 * \return IAP2_OK                       On Successful completion of handling the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * 
 * \see
 * \note
 *******************************************************************************/
static S32 iAP2HandleiAP2WiFiInformation(iAP2Device_st* this_iAP2Device, iAP2WiFiInformationParameter theiAP2WiFiInformationParameter)
{
    S32 rc = IAP2_OK;

    if(this_iAP2Device->iAP2CSCallbacks.iAP2WiFiInformation_cb != NULL)
    {
        (*this_iAP2Device->iAP2CSCallbacks.iAP2WiFiInformation_cb) (this_iAP2Device, &theiAP2WiFiInformationParameter, this_iAP2Device->iAP2ContextCallback);
        IAP2SESSIONDLTLOG(DLT_LOG_VERBOSE, "iAP2WiFiInformation_cb() Callback called DevID:%p",this_iAP2Device);
    }

    return rc;
}

/***************************************************************************//**
 * Parse the messages from Apple Device & Appropriately responds with iAP2 Messages or Intimates to Mother Company regarding the status.
 * 
 * \param thisDevice    Structure having information about the device connected to the target.
 * \param p_SourceBuf   Source Buffer contaning the message from Apple Device which has to be parsed.
 * \param SourceBufSize Size of the Source Buffer.
 * 
 * \return IAP2_OK                       On Successful completion of parsing the message that has been sent by Apple Device.
 * \return IAP2_INVALID_INPUT_PARAMETER  When the input pointer is NULL.
 * \return IAP2_INVALID_START_OF_BYTES   When the Start of Bytes are invalid.
 * \return IAP2_ERROR_INVALID_MESSAGE    When the message length is less than the basic message header length.
 * \return IAP2_ERR_NO_MEM               While unable to allocate memory.
 * \return IAP2_INVALID_PARAMETER_COUNT  When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * \return IAP2_UNKNOWN_MSG_ID           When the Message ID doesn not match with MessageID's mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseDeviceMessage(iAP2Device_st* this_iAP2Device, U8* p_SourceBuf, U32 SourceBufSize)
{
    S32 rc = IAP2_OK;
    U16 msgID = 0x0000;
    U16 msgLength = 0x0000;

    if( (this_iAP2Device != NULL) && (p_SourceBuf != NULL) )
    {
        if(SourceBufSize < IAP2_MSG_HEADER_SIZE)
        {
            rc = IAP2_ERROR_INVALID_MESSAGE;
        }
        if (rc == IAP2_OK)
        {
            rc = iAP2CheckStartOfMsg(p_SourceBuf);
        }
        if (rc == IAP2_OK)
        {
            msgLength = iAP2GetIDorLength(&p_SourceBuf[IAP2_MSG_LENGTH_OFFSET]);
            if(msgLength <= SourceBufSize)
            {
                msgID     = iAP2GetIDorLength(&p_SourceBuf[IAP2_MSG_LENGTH_OFFSET + IAP2_ID_OFFSET]);

                switch(msgID)
                {
                    case IAP2_MSG_ID_AUTHENTICATION_FAILED:
                    {
                        iAP2AuthenticationFailedParameter theiAP2AuthenticationFailedParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2AuthenticationFailed Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2AuthenticationFailedParameter, 0, sizeof(iAP2AuthenticationFailedParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2AuthenticationFailedParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2AuthenticationFailed(this_iAP2Device, theiAP2AuthenticationFailedParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2AuthenticationFailed() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2AuthenticationFailedParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_AUTHENTICATION_SUCCEEDED:
                    {
                        iAP2AuthenticationSucceededParameter theiAP2AuthenticationSucceededParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2AuthenticationSucceeded Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2AuthenticationSucceededParameter, 0, sizeof(iAP2AuthenticationSucceededParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2AuthenticationSucceededParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2AuthenticationSucceeded(this_iAP2Device, theiAP2AuthenticationSucceededParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2AuthenticationSucceeded() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2AuthenticationSucceededParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_REQUEST_AUTHENTICATION_CERTIFICATE:
                    {
                        iAP2RequestAuthenticationCertificateParameter theiAP2RequestAuthenticationCertificateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2RequestAuthenticationCertificate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2RequestAuthenticationCertificateParameter, 0, sizeof(iAP2RequestAuthenticationCertificateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2RequestAuthenticationCertificateParameter(&theiAP2RequestAuthenticationCertificateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2RequestAuthenticationCertificate(this_iAP2Device, theiAP2RequestAuthenticationCertificateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2RequestAuthenticationCertificate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2RequestAuthenticationCertificateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_REQUEST_AUTHENTICATION_CHALLENGE_RESPONSE:
                    {
                        iAP2RequestAuthenticationChallengeResponseParameter theiAP2RequestAuthenticationChallengeResponseParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2RequestAuthenticationChallengeResponse Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2RequestAuthenticationChallengeResponseParameter, 0, sizeof(iAP2RequestAuthenticationChallengeResponseParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2RequestAuthenticationChallengeResponseParameter(&theiAP2RequestAuthenticationChallengeResponseParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2RequestAuthenticationChallengeResponse(this_iAP2Device, theiAP2RequestAuthenticationChallengeResponseParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2RequestAuthenticationChallengeResponse() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2RequestAuthenticationChallengeResponseParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_START_IDENTIFICATION:
                    {
                        iAP2StartIdentificationParameter theiAP2StartIdentificationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StartIdentification Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StartIdentificationParameter, 0, sizeof(iAP2StartIdentificationParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2StartIdentificationParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StartIdentification(this_iAP2Device, theiAP2StartIdentificationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StartIdentification() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StartIdentificationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_IDENTIFICATION_ACCEPTED:
                    {
                        iAP2IdentificationAcceptedParameter theiAP2IdentificationAcceptedParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2IdentificationAccepted Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2IdentificationAcceptedParameter, 0, sizeof(iAP2IdentificationAcceptedParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2IdentificationAcceptedParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2IdentificationAccepted(this_iAP2Device, theiAP2IdentificationAcceptedParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2IdentificationAccepted() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2IdentificationAcceptedParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_IDENTIFICATION_REJECTED:
                    {
                        iAP2IdentificationRejectedParameter theiAP2IdentificationRejectedParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2IdentificationRejected Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2IdentificationRejectedParameter, 0, sizeof(iAP2IdentificationRejectedParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2IdentificationRejectedParameter(&theiAP2IdentificationRejectedParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2IdentificationRejected(this_iAP2Device, theiAP2IdentificationRejectedParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2IdentificationRejected() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2IdentificationRejectedParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_OOBBT_PAIRING_LINK_KEY_INFORMATION:
                    {
                        iAP2OOBBTPairingLinkKeyInformationParameter theiAP2OOBBTPairingLinkKeyInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2OOBBTPairingLinkKeyInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2OOBBTPairingLinkKeyInformationParameter, 0, sizeof(iAP2OOBBTPairingLinkKeyInformationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2OOBBTPairingLinkKeyInformationParameter(&theiAP2OOBBTPairingLinkKeyInformationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2OOBBTPairingLinkKeyInformation(this_iAP2Device, theiAP2OOBBTPairingLinkKeyInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2OOBBTPairingLinkKeyInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2OOBBTPairingLinkKeyInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_START_OOBBT_PAIRING:
                    {
                        iAP2StartOOBBTPairingParameter theiAP2StartOOBBTPairingParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StartOOBBTPairing Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StartOOBBTPairingParameter, 0, sizeof(iAP2StartOOBBTPairingParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2StartOOBBTPairingParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StartOOBBTPairing(this_iAP2Device, theiAP2StartOOBBTPairingParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StartOOBBTPairing() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StartOOBBTPairingParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_STOP_OOBBT_PAIRING:
                    {
                        iAP2StopOOBBTPairingParameter theiAP2StopOOBBTPairingParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StopOOBBTPairing Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StopOOBBTPairingParameter, 0, sizeof(iAP2StopOOBBTPairingParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2StopOOBBTPairingParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StopOOBBTPairing(this_iAP2Device, theiAP2StopOOBBTPairingParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StopOOBBTPairing() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StopOOBBTPairingParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_ROUTE_GUIDANCE_MANEUVER_UPDATE:
                    {
                        iAP2RouteGuidanceManeuverUpdateParameter theiAP2RouteGuidanceManeuverUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2RouteGuidanceManeuverUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2RouteGuidanceManeuverUpdateParameter, 0, sizeof(iAP2RouteGuidanceManeuverUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2RouteGuidanceManeuverUpdateParameter(&theiAP2RouteGuidanceManeuverUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2RouteGuidanceManeuverUpdate(this_iAP2Device, theiAP2RouteGuidanceManeuverUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2RouteGuidanceManeuverUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2RouteGuidanceManeuverUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_ROUTE_GUIDANCE_UPDATE:
                    {
                        iAP2RouteGuidanceUpdateParameter theiAP2RouteGuidanceUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2RouteGuidanceUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2RouteGuidanceUpdateParameter, 0, sizeof(iAP2RouteGuidanceUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2RouteGuidanceUpdateParameter(&theiAP2RouteGuidanceUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2RouteGuidanceUpdate(this_iAP2Device, theiAP2RouteGuidanceUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2RouteGuidanceUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2RouteGuidanceUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_ASSISTIVE_TOUCH_INFORMATION:
                    {
                        iAP2AssistiveTouchInformationParameter theiAP2AssistiveTouchInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2AssistiveTouchInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2AssistiveTouchInformationParameter, 0, sizeof(iAP2AssistiveTouchInformationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2AssistiveTouchInformationParameter(&theiAP2AssistiveTouchInformationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2AssistiveTouchInformation(this_iAP2Device, theiAP2AssistiveTouchInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2AssistiveTouchInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2AssistiveTouchInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_BLUETOOTH_CONNECTION_UPDATE:
                    {
                        iAP2BluetoothConnectionUpdateParameter theiAP2BluetoothConnectionUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2BluetoothConnectionUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2BluetoothConnectionUpdateParameter, 0, sizeof(iAP2BluetoothConnectionUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2BluetoothConnectionUpdateParameter(&theiAP2BluetoothConnectionUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2BluetoothConnectionUpdate(this_iAP2Device, theiAP2BluetoothConnectionUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2BluetoothConnectionUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2BluetoothConnectionUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        /* As the message has group type, free the group type alone */
                        iAP2FreeiAP2BluetoothConnectionUpdateParameter(&theiAP2BluetoothConnectionUpdateParameter);
                    }
                    break;

                    case IAP2_MSG_ID_CALL_STATE_UPDATE:
                    {
                        /* Check whether Application has registered the callback for Deprecated Message, if so parse the Deprecated message */
                        if(this_iAP2Device->iAP2CSCallbacks.iAP2TelephonyCallStateInformation_cb != NULL)
                        {
                            iAP2TelephonyCallStateInformationParameter theiAP2TelephonyCallStateInformationParameter;

                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Message iAP2TelephonyCallStateInformation is Deprecated but application has registered for its callback, Please dont use it. Kindly refer the Apple specification");
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2TelephonyCallStateInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                            memset(&theiAP2TelephonyCallStateInformationParameter, 0, sizeof(iAP2TelephonyCallStateInformationParameter) );
                            iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                            rc = iAP2ParseiAP2TelephonyCallStateInformationParameter(&theiAP2TelephonyCallStateInformationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                            if(rc == IAP2_OK)
                            {
                                rc = iAP2HandleiAP2TelephonyCallStateInformation(this_iAP2Device, theiAP2TelephonyCallStateInformationParameter);
                                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2TelephonyCallStateInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                            else
                            {
                                IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2TelephonyCallStateInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                        }
                        else
                        {
                            iAP2CallStateUpdateParameter theiAP2CallStateUpdateParameter;

                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2CallStateUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                            memset(&theiAP2CallStateUpdateParameter, 0, sizeof(iAP2CallStateUpdateParameter) );
                            iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                            rc = iAP2ParseiAP2CallStateUpdateParameter(&theiAP2CallStateUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                            if(rc == IAP2_OK)
                            {
                                rc = iAP2HandleiAP2CallStateUpdate(this_iAP2Device, theiAP2CallStateUpdateParameter);
                                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2CallStateUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                            else
                            {
                                IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2CallStateUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                        }
                    }
                    break;

                    case IAP2_MSG_ID_COMMUNICATIONS_UPDATE:
                    {
                        /* Check whether Application has registered the callback for Deprecated Message, if so parse the Deprecated message */
                        if(this_iAP2Device->iAP2CSCallbacks.iAP2TelephonyUpdate_cb != NULL)
                        {
                            iAP2TelephonyUpdateParameter theiAP2TelephonyUpdateParameter;

                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Message iAP2TelephonyUpdate is Deprecated but application has registered for its callback, Please dont use it. Kindly refer the Apple specification");
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2TelephonyUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                            memset(&theiAP2TelephonyUpdateParameter, 0, sizeof(iAP2TelephonyUpdateParameter) );
                            iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                            rc = iAP2ParseiAP2TelephonyUpdateParameter(&theiAP2TelephonyUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                            if(rc == IAP2_OK)
                            {
                                rc = iAP2HandleiAP2TelephonyUpdate(this_iAP2Device, theiAP2TelephonyUpdateParameter);
                                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2TelephonyUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                            else
                            {
                                IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2TelephonyUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                        }
                        else
                        {
                            iAP2CommunicationsUpdateParameter theiAP2CommunicationsUpdateParameter;

                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2CommunicationsUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                            memset(&theiAP2CommunicationsUpdateParameter, 0, sizeof(iAP2CommunicationsUpdateParameter) );
                            iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                            rc = iAP2ParseiAP2CommunicationsUpdateParameter(&theiAP2CommunicationsUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                            if(rc == IAP2_OK)
                            {
                                rc = iAP2HandleiAP2CommunicationsUpdate(this_iAP2Device, theiAP2CommunicationsUpdateParameter);
                                IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2CommunicationsUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                            else
                            {
                                IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2CommunicationsUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                            }
                        }
                    }
                    break;

                    case IAP2_MSG_ID_LIST_UPDATE:
                    {
                        iAP2ListUpdateParameter theiAP2ListUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2ListUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2ListUpdateParameter, 0, sizeof(iAP2ListUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2ListUpdateParameter(&theiAP2ListUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2ListUpdate(this_iAP2Device, theiAP2ListUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2ListUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2ListUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        /* As the message has group type, free the group type alone */
                        iAP2FreeiAP2ListUpdateParameter(&theiAP2ListUpdateParameter);
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_AUTHENTICATION_CERTIFICATE:
                    {
                        iAP2DeviceAuthenticationCertificateParameter theiAP2DeviceAuthenticationCertificateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceAuthenticationCertificate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceAuthenticationCertificateParameter, 0, sizeof(iAP2DeviceAuthenticationCertificateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceAuthenticationCertificateParameter(&theiAP2DeviceAuthenticationCertificateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceAuthenticationCertificate(this_iAP2Device, theiAP2DeviceAuthenticationCertificateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceAuthenticationCertificate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceAuthenticationCertificateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_AUTHENTICATION_RESPONSE:
                    {
                        iAP2DeviceAuthenticationResponseParameter theiAP2DeviceAuthenticationResponseParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceAuthenticationResponse Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceAuthenticationResponseParameter, 0, sizeof(iAP2DeviceAuthenticationResponseParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceAuthenticationResponseParameter(&theiAP2DeviceAuthenticationResponseParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceAuthenticationResponse(this_iAP2Device, theiAP2DeviceAuthenticationResponseParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceAuthenticationResponse() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceAuthenticationResponseParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_INFORMATION_UPDATE:
                    {
                        iAP2DeviceInformationUpdateParameter theiAP2DeviceInformationUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceInformationUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceInformationUpdateParameter, 0, sizeof(iAP2DeviceInformationUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceInformationUpdateParameter(&theiAP2DeviceInformationUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceInformationUpdate(this_iAP2Device, theiAP2DeviceInformationUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceInformationUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceInformationUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_LANGUAGE_UPDATE:
                    {
                        iAP2DeviceLanguageUpdateParameter theiAP2DeviceLanguageUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceLanguageUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceLanguageUpdateParameter, 0, sizeof(iAP2DeviceLanguageUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceLanguageUpdateParameter(&theiAP2DeviceLanguageUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceLanguageUpdate(this_iAP2Device, theiAP2DeviceLanguageUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceLanguageUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceLanguageUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_TIME_UPDATE:
                    {
                        iAP2DeviceTimeUpdateParameter theiAP2DeviceTimeUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceTimeUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceTimeUpdateParameter, 0, sizeof(iAP2DeviceTimeUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceTimeUpdateParameter(&theiAP2DeviceTimeUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceTimeUpdate(this_iAP2Device, theiAP2DeviceTimeUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceTimeUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceTimeUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_UUID_UPDATE:
                    {
                        iAP2DeviceUUIDUpdateParameter theiAP2DeviceUUIDUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceUUIDUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceUUIDUpdateParameter, 0, sizeof(iAP2DeviceUUIDUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceUUIDUpdateParameter(&theiAP2DeviceUUIDUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceUUIDUpdate(this_iAP2Device, theiAP2DeviceUUIDUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceUUIDUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceUUIDUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_WIRELESS_CAR_PLAY_UPDATE:
                    {
                        iAP2WirelessCarPlayUpdateParameter theiAP2WirelessCarPlayUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2WirelessCarPlayUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2WirelessCarPlayUpdateParameter, 0, sizeof(iAP2WirelessCarPlayUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2WirelessCarPlayUpdateParameter(&theiAP2WirelessCarPlayUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2WirelessCarPlayUpdate(this_iAP2Device, theiAP2WirelessCarPlayUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2WirelessCarPlayUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2WirelessCarPlayUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_TRANSPORT_IDENTIFIER_NOTIFICATION:
                    {
                        iAP2DeviceTransportIdentifierNotificationParameter theiAP2DeviceTransportIdentifierNotificationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceTransportIdentifierNotification Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceTransportIdentifierNotificationParameter, 0, sizeof(iAP2DeviceTransportIdentifierNotificationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceTransportIdentifierNotificationParameter(&theiAP2DeviceTransportIdentifierNotificationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceTransportIdentifierNotification(this_iAP2Device, theiAP2DeviceTransportIdentifierNotificationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceTransportIdentifierNotification() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceTransportIdentifierNotificationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_START_EXTERNAL_ACCESSORY_PROTOCOL_SESSION:
                    {
                        iAP2StartExternalAccessoryProtocolSessionParameter theiAP2StartExternalAccessoryProtocolSessionParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StartExternalAccessoryProtocolSession Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StartExternalAccessoryProtocolSessionParameter, 0, sizeof(iAP2StartExternalAccessoryProtocolSessionParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2StartExternalAccessoryProtocolSessionParameter(&theiAP2StartExternalAccessoryProtocolSessionParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StartExternalAccessoryProtocolSession(this_iAP2Device, theiAP2StartExternalAccessoryProtocolSessionParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StartExternalAccessoryProtocolSession() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StartExternalAccessoryProtocolSessionParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_STOP_EXTERNAL_ACCESSORY_PROTOCOL_SESSION:
                    {
                        iAP2StopExternalAccessoryProtocolSessionParameter theiAP2StopExternalAccessoryProtocolSessionParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StopExternalAccessoryProtocolSession Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StopExternalAccessoryProtocolSessionParameter, 0, sizeof(iAP2StopExternalAccessoryProtocolSessionParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2StopExternalAccessoryProtocolSessionParameter(&theiAP2StopExternalAccessoryProtocolSessionParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StopExternalAccessoryProtocolSession(this_iAP2Device, theiAP2StopExternalAccessoryProtocolSessionParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StopExternalAccessoryProtocolSession() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StopExternalAccessoryProtocolSessionParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_DEVICE_HID_REPORT:
                    {
                        iAP2DeviceHIDReportParameter theiAP2DeviceHIDReportParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2DeviceHIDReport Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2DeviceHIDReportParameter, 0, sizeof(iAP2DeviceHIDReportParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2DeviceHIDReportParameter(&theiAP2DeviceHIDReportParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2DeviceHIDReport(this_iAP2Device, theiAP2DeviceHIDReportParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2DeviceHIDReport() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2DeviceHIDReportParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_START_NATIVE_HID:
                    {
                        iAP2StartNativeHIDParameter theiAP2StartNativeHIDParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StartNativeHID Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StartNativeHIDParameter, 0, sizeof(iAP2StartNativeHIDParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2StartNativeHIDParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StartNativeHID(this_iAP2Device, theiAP2StartNativeHIDParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StartNativeHID() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StartNativeHIDParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_GPRMC_DATA_STATUS_VALUES_NOTIFICATION:
                    {
                        iAP2GPRMCDataStatusValuesNotificationParameter theiAP2GPRMCDataStatusValuesNotificationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2GPRMCDataStatusValuesNotification Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2GPRMCDataStatusValuesNotificationParameter, 0, sizeof(iAP2GPRMCDataStatusValuesNotificationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2GPRMCDataStatusValuesNotificationParameter(&theiAP2GPRMCDataStatusValuesNotificationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2GPRMCDataStatusValuesNotification(this_iAP2Device, theiAP2GPRMCDataStatusValuesNotificationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2GPRMCDataStatusValuesNotification() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2GPRMCDataStatusValuesNotificationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_START_LOCATION_INFORMATION:
                    {
                        iAP2StartLocationInformationParameter theiAP2StartLocationInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StartLocationInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StartLocationInformationParameter, 0, sizeof(iAP2StartLocationInformationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2StartLocationInformationParameter(&theiAP2StartLocationInformationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StartLocationInformation(this_iAP2Device, theiAP2StartLocationInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StartLocationInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StartLocationInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_STOP_LOCATION_INFORMATION:
                    {
                        iAP2StopLocationInformationParameter theiAP2StopLocationInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StopLocationInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StopLocationInformationParameter, 0, sizeof(iAP2StopLocationInformationParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2StopLocationInformationParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StopLocationInformation(this_iAP2Device, theiAP2StopLocationInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StopLocationInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StopLocationInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_MEDIA_LIBRARY_INFORMATION:
                    {
                        iAP2MediaLibraryInformationParameter theiAP2MediaLibraryInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2MediaLibraryInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2MediaLibraryInformationParameter, 0, sizeof(iAP2MediaLibraryInformationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2MediaLibraryInformationParameter(&theiAP2MediaLibraryInformationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2MediaLibraryInformation(this_iAP2Device, theiAP2MediaLibraryInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2MediaLibraryInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2MediaLibraryInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        /* As the message has group type, free the group type alone */
                        iAP2FreeiAP2MediaLibraryInformationParameter(&theiAP2MediaLibraryInformationParameter);
                    }
                    break;

                    case IAP2_MSG_ID_MEDIA_LIBRARY_UPDATE:
                    {
                        iAP2MediaLibraryUpdateParameter theiAP2MediaLibraryUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2MediaLibraryUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2MediaLibraryUpdateParameter, 0, sizeof(iAP2MediaLibraryUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2MediaLibraryUpdateParameter(&theiAP2MediaLibraryUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2MediaLibraryUpdate(this_iAP2Device, theiAP2MediaLibraryUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2MediaLibraryUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2MediaLibraryUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        /* As the message has group type, free the group type alone */
                        iAP2FreeiAP2MediaLibraryUpdateParameter(&theiAP2MediaLibraryUpdateParameter);
                    }
                    break;

                    case IAP2_MSG_ID_NOW_PLAYING_UPDATE_PARAMETER:
                    {
                        iAP2NowPlayingUpdateParameter theiAP2NowPlayingUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2NowPlayingUpdateParameter Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2NowPlayingUpdateParameter, 0, sizeof(iAP2NowPlayingUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2NowPlayingUpdateParameter(&theiAP2NowPlayingUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2NowPlayingUpdateParameter(this_iAP2Device, theiAP2NowPlayingUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2NowPlayingUpdateParameter() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2NowPlayingUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        /* As the message has group type, free the group type alone */
                        iAP2FreeiAP2NowPlayingUpdateParameter(&theiAP2NowPlayingUpdateParameter);
                    }
                    break;

                    case IAP2_MSG_ID_POWER_UPDATE:
                    {
                        iAP2PowerUpdateParameter theiAP2PowerUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2PowerUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2PowerUpdateParameter, 0, sizeof(iAP2PowerUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2PowerUpdateParameter(&theiAP2PowerUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2PowerUpdate(this_iAP2Device, theiAP2PowerUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2PowerUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2PowerUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_USB_DEVICE_MODE_AUDIO_INFORMATION:
                    {
                        iAP2USBDeviceModeAudioInformationParameter theiAP2USBDeviceModeAudioInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2USBDeviceModeAudioInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2USBDeviceModeAudioInformationParameter, 0, sizeof(iAP2USBDeviceModeAudioInformationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2USBDeviceModeAudioInformationParameter(&theiAP2USBDeviceModeAudioInformationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2USBDeviceModeAudioInformation(this_iAP2Device, theiAP2USBDeviceModeAudioInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2USBDeviceModeAudioInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2USBDeviceModeAudioInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_START_VEHICLE_STATUS_UPDATES:
                    {
                        iAP2StartVehicleStatusUpdatesParameter theiAP2StartVehicleStatusUpdatesParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StartVehicleStatusUpdates Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StartVehicleStatusUpdatesParameter, 0, sizeof(iAP2StartVehicleStatusUpdatesParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2StartVehicleStatusUpdatesParameter(&theiAP2StartVehicleStatusUpdatesParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StartVehicleStatusUpdates(this_iAP2Device, theiAP2StartVehicleStatusUpdatesParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StartVehicleStatusUpdates() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StartVehicleStatusUpdatesParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_STOP_VEHICLE_STATUS_UPDATES:
                    {
                        iAP2StopVehicleStatusUpdatesParameter theiAP2StopVehicleStatusUpdatesParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2StopVehicleStatusUpdates Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2StopVehicleStatusUpdatesParameter, 0, sizeof(iAP2StopVehicleStatusUpdatesParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2StopVehicleStatusUpdatesParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2StopVehicleStatusUpdates(this_iAP2Device, theiAP2StopVehicleStatusUpdatesParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2StopVehicleStatusUpdates() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2StopVehicleStatusUpdatesParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_VOICE_OVER_CURSOR_UPDATE:
                    {
                        iAP2VoiceOverCursorUpdateParameter theiAP2VoiceOverCursorUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2VoiceOverCursorUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2VoiceOverCursorUpdateParameter, 0, sizeof(iAP2VoiceOverCursorUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2VoiceOverCursorUpdateParameter(&theiAP2VoiceOverCursorUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2VoiceOverCursorUpdate(this_iAP2Device, theiAP2VoiceOverCursorUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2VoiceOverCursorUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2VoiceOverCursorUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_VOICE_OVER_UPDATE:
                    {
                        iAP2VoiceOverUpdateParameter theiAP2VoiceOverUpdateParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2VoiceOverUpdate Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2VoiceOverUpdateParameter, 0, sizeof(iAP2VoiceOverUpdateParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2VoiceOverUpdateParameter(&theiAP2VoiceOverUpdateParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2VoiceOverUpdate(this_iAP2Device, theiAP2VoiceOverUpdateParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2VoiceOverUpdate() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2VoiceOverUpdateParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_REQUEST_ACCESSORY_WI_FI_CONFIGURATION_INFORMATION:
                    {
                        iAP2RequestAccessoryWiFiConfigurationInformationParameter theiAP2RequestAccessoryWiFiConfigurationInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2RequestAccessoryWiFiConfigurationInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2RequestAccessoryWiFiConfigurationInformationParameter, 0, sizeof(iAP2RequestAccessoryWiFiConfigurationInformationParameter) );
                        /* As there are no associated parameters only the message length is provided */
                        rc = iAP2ParseiAP2RequestAccessoryWiFiConfigurationInformationParameter(msgLength);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2RequestAccessoryWiFiConfigurationInformation(this_iAP2Device, theiAP2RequestAccessoryWiFiConfigurationInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2RequestAccessoryWiFiConfigurationInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2RequestAccessoryWiFiConfigurationInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    case IAP2_MSG_ID_WI_FI_INFORMATION:
                    {
                        iAP2WiFiInformationParameter theiAP2WiFiInformationParameter;

                        IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "Received iAP2WiFiInformation Message from Device, Msg ID:%X, Msg Length:0x%X DevID:%p", msgID, msgLength, this_iAP2Device);
                        memset(&theiAP2WiFiInformationParameter, 0, sizeof(iAP2WiFiInformationParameter) );
                        iAP2InitializeBufferPool(this_iAP2Device->iAP2BufferPool);
                        rc = iAP2ParseiAP2WiFiInformationParameter(&theiAP2WiFiInformationParameter, p_SourceBuf, msgLength, this_iAP2Device->iAP2BufferPool);
                        if(rc == IAP2_OK)
                        {
                            rc = iAP2HandleiAP2WiFiInformation(this_iAP2Device, theiAP2WiFiInformationParameter);
                            IAP2SESSIONDLTLOG(DLT_LOG_DEBUG, "iAP2HandleiAP2WiFiInformation() returns rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                        else
                        {
                            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2ParseiAP2WiFiInformationParameter(): rc = %d DevID:%p", rc, this_iAP2Device);
                        }
                    }
                    break;

                    default:
                    {
                        rc = IAP2_UNKNOWN_MSG_ID;
                        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Received Unknown Control Session Message. DevID:%p", this_iAP2Device);
                    }
                    break;
                }
            }
            else
            {
                rc = IAP2_ERROR_INVALID_MESSAGE;
                IAP2SESSIONDLTLOG(DLT_LOG_WARN, "msgLength %d exceeds the SourceBufSize %d ", msgLength, SourceBufSize);
            }
        }
        else
        {
            IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "iAP2CheckStartOfMsg(): rc = %d DevID:%p", rc, this_iAP2Device);
        }
    }
    else
    {
        rc = IAP2_INVALID_INPUT_PARAMETER;
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "Invalid Input Parameter. this_iAP2Device = %p, p_SourceBuf = %p", this_iAP2Device ,p_SourceBuf);
    }

    return rc;
}

/** @} */
